<?php
//code_nashodeh
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 6.1.0
 */

defined( 'ABSPATH' ) || exit;


global $product;

$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

do_action( 'woocommerce_before_add_to_cart_form' ); ?>



    <form class="variations_form cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo $variations_attr; // WPCS: XSS ok. ?>">
        <?php do_action( 'woocommerce_before_variations_form' ); ?>

        <div class="row">
            <div class="col-lg-6 float-right mb-4">
                <div class="progress-product mb-3">
                    <?php
                    $categories = get_the_terms(get_the_ID() , 'product_cat');

                    foreach ($categories as $item):
                        echo '<a href="'.$item->slug.'">'.$item->name.'</a><span>/</span>';
                    endforeach;
                    ?>
                </div>
                <h1 class="product-name mb-3"><?php the_title() ?></h1>
                <p class="short-description mb-3"><?php echo get_post_meta( get_the_ID(), '_krb_English_name__product', true ); ?></p>

                <p class="average-score d-flex align-items-center"><span class="icon-Favorite">
                    </span> <?php do_shortcode('woocommerce_template_single_rating') ?> <span>
                        <?php count_buy_product(get_the_ID()); ?>
                    </span>
                </p>


                <?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
                    <p class="stock out-of-stock"><?php echo esc_html( apply_filters( 'woocommerce_out_of_stock_message', __( 'This product is currently out of stock and unavailable.', 'woocommerce' ) ) ); ?></p>
                <?php endif; ?>


                <?php attribute_product(1); ?>
            </div>
            <div class="col-lg-6 float-right mb-4">
                <div class="product-sidebar bg-white p-4 h-100 d-flex flex-column justify-content-between">
                    <div class="product-sidebar-head w-100 d-flex align-items-center justify-content-between">
                        <h5 class="product-sidebar_seller">فروشنده</h5>
                        <span class="other-sellers">۷ فروشنده دیگر</span>
                    </div>
                    <p class="name-seller d-flex align-items-center"><span class="icon-shop"></span> گسترش همراه</p>
                    <div class="function d-flex align-items-center">
                        <span>۹۱.۲%  رضایت از کالا</span>
                        <p>عملکرد <span> عالی</span></p>
                    </div>
                    <div class="warranty">
                        <p class="d-flex align-items-center"> <span class="icon-shield6"></span>گارانتی ۱۸ ماهه آرکا تجارت بیستون</p>
                    </div>
                    <div class="source-goods d-flex align-items-center justify-content-between">
                        <p class="d-flex align-items-center"><span class="icon-approve-folder icon_folder"></span> موجود در انبار دیجیکالا</p>
                        <a href="#"><span class="icon-arrow-left2"></span></a>
                    </div>
                    <div class="send-goods">
                        <p class="d-flex align-items-center"><span class="icon-shipping-truck icon_truck"></span> ارسال دیجی‌کالا</p>
                    </div>
                    <div class="send-goods d-flex align-items-center justify-content-between">
                        <p class="d-flex align-items-center"><span class="icon-approve-user icon_user"></span> ۱۵۰ امتیاز دیجی‌کلاب</p>
                        <span class="icon-Exclamation-Mark-1"></span>
                    </div>
                    <div class="price-wrapper d-none d-lg-flex align-items-center justify-content-between">
                        <p class="price-text">قیمت فروشنده</p>
                        <span class="price"><?php echo do_action('krb_price'); ?></span>
                    </div>
                    <?php $p = price_product(get_the_ID()); ?>
                    <?php  if($p['instock']['count']): ?>
                        <p class="inventory">تنها <?php echo $p['instock']['count']; ?> عدد در انبار باقی مانده</p>
                    <?php endif; ?>




                    <?php
                    if ( !empty( $available_variations ) || false == $available_variations ):
                        /**
                         * Hook: woocommerce_before_single_variation.
                         */
                        do_action( 'woocommerce_before_single_variation' );

                        /**
                         * Hook: woocommerce_single_variation. Used to output the cart button and placeholder for variation data.
                         *
                         * @since 2.4.0
                         * @hooked woocommerce_single_variation - 10 Empty div for variation data.
                         * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
                         */
                        do_action( 'woocommerce_single_variation' );
                        /**
                         * Hook: woocommerce_after_single_variation.
                         */
                        do_action( 'woocommerce_after_single_variation' );
                    endif;
                    ?>




                </div>

            </div>
        </div>





        <?php do_action( 'woocommerce_after_variations_form' ); ?>
    </form>

<div class="nav-bottom-price d-block d-lg-none">
        <div class="d-flex align-items-center justify-content-between h-100">
            <div class="nav-bottom_right h-100 d-flex align-items-center justify-content-center">
            </div>
            <div class="nav-bottom_left  h-100 d-flex align-items-center justify-content-center">
                <div class="d-flex align-items-center justify-content-center flex-column flex-grow-1">
                    <div class="price-wrapper d-flex align-items-center justify-content-around w-100">
                        <p class="price-text">قیمت اصلی</p>
                        <span class="price"> 52,200,000 تومان</span>
                    </div>
                    <div class="off-wrapper d-flex align-items-center justify-content-around w-100">
                        <p class="price-text"> قیمت با تخفیف</p>
                        <span class="price"> 50,200,000  تومان</span>
                    </div>
                </div>
                <p class="product-off">26%</p>
            </div>
        </div>
    </div>




<?php
do_action( 'woocommerce_after_add_to_cart_form' );
