<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package karbon
 */

get_header();

while ( have_posts() ) :
    the_post();
    setPostViews(get_the_ID());
    ?>
    <!-- blog -->
    <section class="single-blog py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 mb-4">
                    <article>
                        <h1><?php echo the_title() ?></h1>
                        <div class="single-blog-head d-flex align-items-center flex-column flex-md-row">
                            <div class="single-blog-head_img img-container">
                                <div class="img-container-inner img-cover">
                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php echo the_title(); ?>">
                                </div>
                            </div>
                            <div>
                                <div class="single-blog-head_text"><?php the_excerpt(); ?></div>
                                <div class="post-details d-flex align-items-center">
                                    <?php $comments_count = wp_count_comments( get_the_ID() ); ?>
                                    <p class="post__details d-flex align-items-center"><span class="icon-typing1"></span> <?php echo number_format_i18n( $comments_count->approved ); ?> نظر</p>
                                    <p class="post__details d-flex align-items-center"><span class="icon-calendar1"></span><?php echo get_the_date("j F, Y") ?></p>
                                </div>
                            </div>
                        </div>
                        <?php the_content(); ?>
                    </article>
                </div>
                <?php get_template_part('template-parts/sidebar-blog'); ?>
            </div>
        </div>
    </section>
    <!-- comment -->
    <section  class="comment-product py-5" id="opinions">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h4 class="product-specifications_title">  دیدگاه کاربران</h4>
                    <?php
                    $comments = $comments = get_comments(array(
                        'post_id' => get_the_ID()));
                    foreach ($comments as $comment):
                        if($comment->comment_approved == 1):
?>
                        <div class="comment-wrapper d-flex align-items-start align-items-sm-center">
                            <div class="profile-comment-img img-container">
                                <div class="img-container-inner img-cover">
                                    <img src="<?php echo get_user_logged_in('profile_image') ?>" alt="">
                                </div>
                            </div>
                            <div>
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex align-items-start align-items-sm-center flex-column flex-sm-row">
                                        <p class="comment-name"><?php echo $comment->comment_author ?></p>
                                        <span class="comment-date"><?php echo get_the_date("j F, Y") ?></span>
                                    </div>
                                </div>
                                <p class="comment-text"><?php echo $comment->comment_content ?></p>
                            </div>
                        </div>
                            <?php
                        endif;
                        endforeach;
                    ?>


                        <div class="comment-form w-100">
                                <?php if ( comments_open( get_the_ID() ) ):  ?>
                                    <?php get_template_part( 'components/comments' ); ?>
                                    <?php comments_template( '', true ); ?>
                                <?php endif; ?>
                        </div>
                    
                    
                </div>
            </div>
        </div>
    </section>
<?php
endwhile;
get_footer();
