<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package karbon
 */

get_header();
?>

    <!-- blog -->
    <section class="blog blog-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 mb-4">
                    <div class="row">
                        <?php if ( have_posts() ) : ?>

                            <?php
                            /* Start the Loop */
                            while ( have_posts() ) :
                                the_post();
                                ?>
                                <div class="col-sm-6 mb-4">
                                    <div class="card-blog">
                                        <a href="<?php the_permalink(); ?>" class="blog-img img-container">
                                            <div class="img-container-inner img-cover">
                                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title() ?>">
                                            </div>
                                        </a>
                                        <div class="card-blog-body p-3">
                                            <div class="author-article d-flex align-items-center">
                                                <div class="author-article-img img-container">
                                                    <div class="img-container-inner img-cover">
                                                        <img src="<?php echo get_user_author('profile_image' , get_the_author_ID()); ?>" alt="<?php the_author() ?>">
                                                    </div>
                                                </div>
                                                <a href="<?php echo get_author_posts_url(get_the_ID()); ?>"><p><?php the_author() ?></p></a>
                                            </div>
                                            <a href="<?php the_permalink(); ?>"><h4 class="blog-title mt-2"><?php the_title() ?></h4></a>
                                            <div class="d-flex align-items-center justify-content-end mt-3">
                                                <a href="<?php the_permalink(); ?>" class="arrow-blog d-flex align-items-center justify-content-center">
                                                    <span class="icon-left-arrow"></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                        else:
                           ?>
                            <div class="empty-search d-flex flex-column align-items-center justify-content-center">
                                <img src="<?php echo Karbon_PLG_URI ?>/assets/img/search-img.png" alt="">
                                <p>چیزی یافت نشد</p>
                            </div>
                        <?php
                        endif;
                        ?>
                    </div>
                    <!-- pagination -->
                    <!-- ADD Custom Numbered Pagination code. -->

                    <nav aria-label="Page navigation example" class="d-flex align-items-center justify-content-center mt-5">
                        <ul class="pagination">
                            <?php if(function_exists('pagenavi')) { pagenavi(); } ?>


                            <!--                            <li class="page-item">-->
                            <!--								<a class="page-link page-link-next d-flex align-items-center justify-content-center" href="#" aria-label="Next">-->
                            <!--									<span class="icon-arrow-left2"></span>-->
                            <!--								</a>-->
                            <!--							</li>-->
                        </ul>
                    </nav>
                </div>
                <?php get_template_part('template-parts/sidebar-blog'); ?>
            </div>
        </div>
    </section>

<?php
get_sidebar();
get_footer();
