<?php
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
function my_theme_enqueue_styles() {
    $parenthandle = 'parent-style'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.
    $theme        = wp_get_theme();
    wp_enqueue_style( $parenthandle,
        get_template_directory_uri() . '/style.css',
        array(),  // If the parent theme code has a dependency, copy it to here.
        $theme->parent()->get( 'Version' ),
    );
    wp_enqueue_style( 'child-style',
        get_stylesheet_uri(),
        array( $parenthandle ),
        $theme->get( 'Version' ), // This only works if you have Version defined in the style header.
    );
}

/**
 * Add a content in a notice instead. Let's add it before other notices with a priority = 9
 *
 * Reference: https://github.com/woothemes/woocommerce/blob/master/templates/checkout/form-checkout.php
 */
//add_action( 'woocommerce_before_checkout_form', 'skyverge_add_checkout_success', 9 );
//function skyverge_add_checkout_success() {
//    wc_print_notice( __( 'این سایت برای دمو اجرا شده است و خرید و فروشی در آن صورت نمیگیرد' ), 'error' );
//}