
  
  jQuery(document).ready(function ($){
    
function initImageUpload(box) {
  let uploadField = box.querySelector('.image-upload');
  let deleteBtn =box.querySelector('.img-delete-btn');
  let thumb = box.querySelector('.imagePreview')

  uploadField.addEventListener('change', getFile);
  deleteBtn.addEventListener('click', deleteFile);

  function getFile(e){
      let file = e.currentTarget.files[0];
      checkType(file);
    
      deleteBtn.style.display="block"
  }
  function deleteFile(){
      thumb.style.backgroundImage = 'url("../img/prev-upload.png")';
      deleteBtn.style.display="none"
  }
  
  function previewImage(file){
    let reader = new FileReader();

    reader.onload = function() {
      thumb.style.backgroundImage = 'url(' + reader.result + ')';
    }
    reader.readAsDataURL(file);
    thumb.className += 'js--no-default';
  }

  function checkType(file){
    let imageType = /image.*/;
    if (!file.type.match(imageType)) {
      throw 'Datei ist kein Bild';
    } else if (!file){
      throw 'Kein Bild gewählt';
    } else {
      previewImage(file);
    }
  }
  
}

// initialize box-scope
var boxes = document.querySelectorAll('.upload-wrraper');

for (let i = 0; i < boxes.length; i++) {
  let box = boxes[i];
  initImageUpload(box);
}

  } , jQuery);
