

jQuery(document).ready(function ($){
            //range filters sidebar
            class CostForm {
              constructor(parentElement) {
                this.doubleSliderElement = parentElement.querySelector(".range-slider");
                this.doubleSlider = new DoubleSlider(this.doubleSliderElement);
            
                const [minNumberInput, maxNumberInput] = parentElement.querySelectorAll(".range__input");
            
                updateMinMax();
            
                minNumberInput.addEventListener("input", ({target: {value}}) => {
                  this.doubleSlider.min = value;
                  maxNumberInput.min = value;
                });
            
                maxNumberInput.addEventListener("input", ({target: {value}}) => {
                  this.doubleSlider.max = value;
                  minNumberInput.max = value;
                });
            
                this.doubleSliderElement.addEventListener("input", ({target}) => {
                  minNumberInput.value = this.doubleSlider.min;
                  maxNumberInput.value = this.doubleSlider.max;
                  updateMinMax();
                });
            
                function updateMinMax() {
                  minNumberInput.max = maxNumberInput.value;
                  maxNumberInput.min = minNumberInput.value;
                }
              }
            }
            
            class DoubleSlider {
              constructor(element) {
                this.parent = element;
                this.sliders = element.querySelectorAll(".range-slider__input");
                const [minSlider, maxSlider] = this.sliders;
            
                this.propertiesCSS = ["--first-val", "--second-val"];
            
                this.minLength = minSlider.min;
                this.maxLength = minSlider.max;
                this.min = minSlider.value;
                this.max = maxSlider.value;
            
                minSlider.addEventListener("input", ({target}) => {
                  const {value} = target;
            
                  if (Number(value) < Number(maxSlider.value)) {
                    this.min = value;
                  } else {
                    this.max = value;
                  }
                });
            
                maxSlider.addEventListener("input", ({target}) => {
                  const {value} = target;
            
                  if (Number(value) < Number(minSlider.value)) {
                    this.min = value;
                  } else {
                    this.max = value;
                  }
                });
              }
            
              valueToPercent = (value) => {
                const {minLength, maxLength} = this;
                return (value * 100) / (maxLength - minLength);
              };
            
              get max() {
                return this._max;
              }
            
              get min() {
                return this._min;
              }
            
              set max(value) {
                this._max = value;
                const {parent, sliders, valueToPercent} = this;
                parent.style.setProperty("--second-val", `${valueToPercent(value)}%`);
                sliders[1].value = value;
              }
            
              set min(value) {
                this._min = value;
                const {parent, sliders, valueToPercent} = this;
                parent.style.setProperty("--first-val", `${valueToPercent(value)}%`);
                sliders[0].value = value;
              }
            }
            
            let ranges = document.querySelectorAll(".range-wrapper")
            ranges.forEach(range =>{
                new CostForm(range); 
            })
} , jQuery);