

  jQuery(document).ready(function ($){

        var gallery = $("#gallery");
        var thumb1 = $("#thumb1");
        var thumb2 = $("#thumb2");
        var slidesPerPage = 3; 
        var syncedSecondary = true;
    
        gallery.owlCarousel({
            rtl:true,
            items: 1,
            slideSpeed: 2000,
            nav: true,
            autoplay: false, 
            dots: false,
            loop: true,
            // responsiveRefreshRate: 200,
            navText: ['<svg width="100%" height="100%" viewBox="0 0 11 20"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M9.554,1.001l-8.607,8.607l8.607,8.606"/></svg>', '<svg width="100%" height="100%" viewBox="0 0 11 20" version="1.1"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M1.054,18.214l8.606,-8.606l-8.606,-8.607"/></svg>'],
        }).on('changed.owl.carousel', syncPosition);
    
        thumb1
            .on('initialized.owl.carousel', function() {
                thumb1.find(".owl-item").eq(0).addClass("current");
            })
            .owlCarousel({
                rtl:true,
                items: 4,
                margin:10,
                dots: true,
                loop:false,
                nav: true,
                smartSpeed: 200,
                slideSpeed: 500,
                slideBy: slidesPerPage, 
                responsiveRefreshRate: 100
            }).on('changed.owl.carousel', syncPosition2);

        thumb2
            .on('initialized.owl.carousel', function() {
                thumb2.find(".owl-item").eq(0).addClass("current");
            })
            .owlCarousel({
                rtl:true,
                items: 'auto',
                margin:10,
                dots: true,
                loop:false,
                nav: false,
                dots:false,
                smartSpeed: 200,
                slideSpeed: 500,
                slideBy: slidesPerPage, 
                responsiveRefreshRate: 100
            }).on('changed.owl.carousel', syncPosition3);
    
        function syncPosition(el) {
            var count = el.item.count - 1;
            var current = Math.round(el.item.index - (el.item.count / 2) - .5);
    
            if (current < 0) {
                current = count;
            }
            if (current > count) {
                current = 0;
            }
    

    
            thumb1
                .find(".owl-item")
                .removeClass("current")
                .eq(current)
                .addClass("current");
            var onscreen = thumb1.find('.owl-item.active').length - 1;
            var start = thumb1.find('.owl-item.active').first().index();
            var end = thumb1.find('.owl-item.active').last().index();
    
            if (current > end) {
                thumb1.data('owl.carousel').to(current, 100, true);
            }
            if (current < start) {
                thumb1.data('owl.carousel').to(current - onscreen, 100, true);
            }

            thumb2
                .find(".owl-item")
                .removeClass("current")
                .eq(current)
                .addClass("current");
            var onscreen = thumb2.find('.owl-item.active').length - 1;
            var start = thumb2.find('.owl-item.active').first().index();
            var end = thumb2.find('.owl-item.active').last().index();
    
            if (current > end) {
                thumb2.data('owl.carousel').to(current, 100, true);
            }
            if (current < start) {
                thumb2.data('owl.carousel').to(current - onscreen, 100, true);
            }
        }
    
        function syncPosition2(el) {
            if (syncedSecondary) {
                var number = el.item.index;
                gallery.data('owl.carousel').to(number, 100, true);
            }
        }
    
        function syncPosition3(el) {
            if (syncedSecondary) {
                var number2 = el.item.index;
                thumb1.data('owl.carousel').to(number2, 100, true);
            }
        }
    
        thumb1.on("click", ".owl-item", function(e) {
            e.preventDefault();
            var number = $(this).index();
            gallery.data('owl.carousel').to(number, 300, true);
        });
        thumb2.on("click", ".owl-item", function(e) {
            e.preventDefault();
            var number2 = $(this).index();
            gallery.data('owl.carousel').to(number2, 300, true);
        });
        

  } , jQuery);

