$(document).ready(function() {

    var productGallery = $("#productGallery");
    var productThumb = $("#productThumb");
    var slidesPerPage = 3; 
    var syncedSecondary = true;

    productGallery.owlCarousel({
        rtl:true,
        items: 1,
        slideSpeed: 2000,
        nav: false,
        autoplay: false, 
        dots: false,
        loop: true,
        responsiveRefreshRate: 200,
        navText: ['<svg width="100%" height="100%" viewBox="0 0 11 20"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M9.554,1.001l-8.607,8.607l8.607,8.606"/></svg>', '<svg width="100%" height="100%" viewBox="0 0 11 20" version="1.1"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M1.054,18.214l8.606,-8.606l-8.606,-8.607"/></svg>'],
    }).on('changed.owl.carousel', syncPosition);

    productThumb
        .on('initialized.owl.carousel', function() {
            productThumb.find(".owl-item").eq(0).addClass("current");
        })
        .owlCarousel({
            rtl:true,
            items: 4,
            dots: false,
            nav: false,
            smartSpeed: 200,
            slideSpeed: 500,
            slideBy: slidesPerPage, 
            responsiveRefreshRate: 100
        }).on('changed.owl.carousel', syncPosition2);

    function syncPosition(el) {
        var count = el.item.count - 1;
        var current = Math.round(el.item.index - (el.item.count / 2) - .5);

        if (current < 0) {
            current = count;
        }
        if (current > count) {
            current = 0;
        }

        productThumb
            .find(".owl-item")
            .removeClass("current")
            .eq(current)
            .addClass("current");
        var onscreen = productThumb.find('.owl-item.active').length - 1;
        var start = productThumb.find('.owl-item.active').first().index();
        var end = productThumb.find('.owl-item.active').last().index();

        if (current > end) {
            productThumb.data('owl.carousel').to(current, 100, true);
        }
        if (current < start) {
            productThumb.data('owl.carousel').to(current - onscreen, 100, true);
        }
    }

    function syncPosition2(el) {
        if (syncedSecondary) {
            var number = el.item.index;
            productGallery.data('owl.carousel').to(number, 100, true);
        }
    }

    productThumb.on("click", ".owl-item", function(e) {
        e.preventDefault();
        var number = $(this).index();
        productGallery.data('owl.carousel').to(number, 300, true);
    });
});